/* converted from ElSami's Superscale filter */

typedef unsigned char bool8;
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef signed char int8;
typedef short int16;
typedef long int32;
typedef unsigned int uint32;

extern "C" void __cdecl superscale_line(uint16 *src0, uint16 *src1, uint16 *src2, uint16 *dst, uint32 width);
extern "C" void __cdecl superscale_line_75(uint16 *src0, uint16 *src1, uint16 *src2, uint16 *dst, uint32 width, const unsigned __int64 *mask);

static const unsigned __int64 mask = 0x7BEF7BEF7BEF7BEF;

void SuperScale(uint8 *src, uint32 srcpitch, uint8 *,uint8 *dst, uint32 dstpitch, int width, int height)
{
	uint16 *dst0 = (uint16*)dst;
	uint16 *dst1 = (uint16*)(dst + dstpitch);
	uint16 *src0 = (uint16*)(src - srcpitch);  //don't worry, there is extra space :)
	uint16 *src1 = (uint16*)src;
	uint16 *src2 = (uint16*)(src + srcpitch);

	while (--height) {
		superscale_line(src0, src1, src2, dst0, width);
		superscale_line(src2, src1, src0, dst1, width);
		src0 = src1;
		src1 = src2;
		src2 += srcpitch / 2;
		dst0 += dstpitch;
		dst1 += dstpitch;
	}
}

void SuperScale75(uint8 *src, uint32 srcpitch, uint8 *,uint8 *dst, uint32 dstpitch, int width, int height)
{
	uint16 *dst0 = (uint16*)dst;
	uint16 *dst1 = (uint16*)(dst + dstpitch);
	uint16 *src0 = (uint16*)(src - srcpitch);  //don't worry, there is extra space :)
	uint16 *src1 = (uint16*)src;
	uint16 *src2 = (uint16*)(src + srcpitch);

	while (--height) {
		superscale_line(src0, src1, src2, dst0, width);
		superscale_line_75(src2, src1, src0, dst1, width, &mask);
		src0 = src1;
		src1 = src2;
		src2 += srcpitch / 2;
		dst0 += dstpitch;
		dst1 += dstpitch;
	}
}
